# CheAI Reports API

This project is a FastAPI-based backend designed to serve analytics and reporting data for the CheAI Restaurant Chatbot. It reads from a MySQL database where chatbot search logs are stored and exposes a set of RESTful endpoints for a frontend dashboard to consume.

## 🚀 Features

The API provides a variety of insights derived from the `ai_logs` table, categorized into several key areas:

-   **Overview Analytics**: Get a high-level view of search activity, including:
    -   Total number of searches.
    -   Number of unique users.
    -   Overall success rate (searches that returned results).
    -   Daily search trends over time.
-   **Food & Cuisine Insights**: Understand user preferences and search patterns:
    -   Top most searched-for food items.
    -   Top most "avoided" or excluded items.
    -   Most common queries that result in zero results, helping to identify gaps in restaurant data.
-   **Restaurant Insights**: Analyze which restaurants are most popular:
    -   Most frequently searched-for restaurants by name.
    -   Restaurants that appear most often as the top recommended result.
-   **Geographic Insights**: See where your users are searching from:
    -   Search volume aggregated by country.
    -   Search success rate broken down by country.

## 🛠️ Tech Stack

-   **Backend Framework**: [FastAPI](https://fastapi.tiangolo.com/)
-   **Database ORM**: [SQLAlchemy](https://www.sqlalchemy.org/) (with asynchronous support)
-   **Database Driver**: [aiomysql](https://github.com/aio-libs/aiomysql)
-   **Data Validation**: [Pydantic](https://docs.pydantic.dev/)
-   **Web Server**: [Uvicorn](https://www.uvicorn.org/)
-   **Database**: MySQL

---

## ⚙️ Setup and Installation

Follow these steps to get the application running locally.

### 1. Prerequisites

-   Python 3.10+
-   A running MySQL database instance.

### 2. Clone the Repository

If you haven't already, clone the project to your local machine.

```bash
git clone <repository-url>
cd CheAI-reports-generator
```

### 3. Create a Virtual Environment

It's highly recommended to use a virtual environment to manage project dependencies.

```bash
# For Windows
python -m venv venv
venv\Scripts\activate

# For macOS/Linux
python3 -m venv venv
source venv/bin/activate
```

### 4. Install Dependencies

Install all the required Python packages.

```bash
pip install -r requirements.txt
```

### 5. Configure Environment Variables

Create a file named `.env` in the root directory of the project. This file will hold your database credentials. Copy the contents of the example below and replace the placeholder values with your actual database details.

**.env file:**
```env
# .env
DB_USER=your_db_user
DB_PASSWORD=your_db_password
DB_HOST=localhost
DB_PORT=3306
DB_NAME=cheai_reports
```

---

## ▶️ Running the Application

Once the setup is complete, you can start the FastAPI server using Uvicorn.

```bash
uvicorn main:app --reload
```

-   `main`: Refers to the `main.py` file.
-   `app`: Refers to the `app = FastAPI()` instance inside `main.py`.
-   `--reload`: This flag enables auto-reloading, so the server will restart automatically after you make changes to the code.

The application will be running at **http://127.0.0.1:8000**.

---

## 📚 API Documentation

This API is self-documenting thanks to FastAPI and OpenAPI. Once the server is running, you can access the interactive API documentation in your browser:

-   **Swagger UI**: [http://127.0.0.1:8000/docs](http://127.0.0.1:8000/docs)
-   **ReDoc**: [http://127.0.0.1:8000/redoc](http://127.0.0.1:8000/redoc)

### API Endpoints

All endpoints are prefixed with `/api/v1`. They accept `start_date` and `end_date` query parameters (in `YYYY-MM-DD` format) to filter the data by a specific time range. If no dates are provided, they default to the last 30 days.

-   `/overview/*`
-   `/food-insights/*`
-   `/restaurant-insights/*`
-   `/geographic-insights/*`

---

## 📂 Project Structure

```
.
├── database/         # SQLAlchemy models and database connection setup
├── routers/          # API endpoint definitions (controllers)
├── services/         # Business logic and database query handling
├── utils/            # Utility functions (e.g., date helpers)
├── config.py         # Application configuration using Pydantic
├── main.py           # Main FastAPI application entry point
├── requirements.txt  # Project dependencies
└── README.md         # This file
```
