import os
from pydantic_settings import BaseSettings
from dotenv import load_dotenv

# Load environment variables from a .env file
load_dotenv()


class Settings(BaseSettings):
    # Database Configuration
    DB_USER: str = os.getenv("DB_USER", "chefoodieglobal")
    DB_PASSWORD: str = os.getenv("DB_PASSWORD", "HK6A)pS3-f=*")
    DB_HOST: str = os.getenv("DB_HOST", "chefoodieglobal.com")
    DB_PORT: int = int(os.getenv("DB_PORT", 3306))
    DB_NAME: str = os.getenv("DB_NAME", "chefoodieglobal_live")

    # SQLAlchemy Database URL
    @property
    def db_connection_url(self) -> str:
        return f"mysql+aiomysql://{self.DB_USER}:{self.DB_PASSWORD}@{self.DB_HOST}:{self.DB_PORT}/{self.DB_NAME}"

    # Project Metadata
    PROJECT_NAME: str = "CheAI Reports API"
    API_V1_STR: str = "/api/v1"


settings = Settings()
