from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from config import settings
from routers import overview, food_insights, restaurant_insights, geographic, user_insights

# Create the FastAPI app instance
app = FastAPI(
    title=settings.PROJECT_NAME,
    openapi_url=f"{settings.API_V1_STR}/openapi.json",
)

# CORS (Cross-Origin Resource Sharing) Middleware
# This allows your frontend to communicate with this backend.
# Replace "http://localhost:3000" with the actual origin of your frontend.
origins = [
    "http://localhost:3000",
    "http://localhost:8000", 
     '*' # Add other origins as needed
]

app.add_middleware(
    CORSMiddleware,
    allow_origins=origins,
    allow_credentials=True,
    allow_methods=["*"],  # Allows all methods (GET, POST, etc.)
    allow_headers=["*"],  # Allows all headers
)

# Include the API routers
app.include_router(overview.router, prefix=settings.API_V1_STR)
app.include_router(food_insights.router, prefix=settings.API_V1_STR)
app.include_router(restaurant_insights.router, prefix=settings.API_V1_STR)
app.include_router(geographic.router, prefix=settings.API_V1_STR)


@app.get("/", tags=["Root"])
async def read_root():
    """
    A simple endpoint to confirm the API is running.
    """
    return {"message": f"Welcome to the {settings.PROJECT_NAME}"}


# To run the application:
# uvicorn main:app --reload
