from datetime import date, datetime, time

def get_date_range(start_date: date, end_date: date) -> tuple[datetime, datetime]:
    """Converts start and end dates to datetime objects for database queries."""
    start_datetime = datetime.combine(start_date, time.min)
    end_datetime = datetime.combine(end_date, time.max)
    return start_datetime, end_datetime
